/**
 * JOnAS: Java(TM) Open Application Server
 * Copyright (C) 1999 Bull S.A.
 * Contact: jonas-team@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * Initial developer(s): Philippe Coq
 * --------------------------------------------------------------------------
 * $Id: CommonEjbXml.java 15428 2008-10-07 11:20:29Z sauthieg $
 * --------------------------------------------------------------------------
 */

package org.ow2.jonas.deployment.ejb.xml;


import org.ow2.jonas.deployment.common.xml.JLinkedList;
import org.ow2.jonas.deployment.common.xml.JndiEnvRefsGroupXml;
/**
 * This interface provides to the value of Xml elements common for session/entity/mdb
 * @author Philippe Coq
 */

public interface CommonEjbXml extends JndiEnvRefsGroupXml {
    /**
     * @return ejb-name element
     */
    String getEjbName();
    /**
     * @return home element
     */
    String getHome();

    /**
     * @return remote element
     */
    String getRemote();

    /**
     * @return local-home  element
     */
    String getLocalHome();

    /**
     * @return local element
     */
    String getLocal();

    /**
     * @return ejb-class element
     */
    String getEjbClass();

    /**
     * Gets the security-identity
     * @return the security-identity
     */
    SecurityIdentity getSecurityIdentity();

    /**
     * Gets the security-role-ref
     * @return the security-role-ref
     */
    JLinkedList getSecurityRoleRefList();
}
