/**
 * JOnAS: Java(TM) Open Application Server
 * Copyright (C) 1999 Bull S.A.
 * Contact: jonas-team@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 *
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * Initial developer: Eric Hardesty
 * --------------------------------------------------------------------------
 * $Id: JonasActivationspecDesc.java 15428 2008-10-07 11:20:29Z sauthieg $
 * --------------------------------------------------------------------------
 */
package org.ow2.jonas.deployment.rar;

import java.io.Serializable;
import java.util.List;

import org.ow2.jonas.deployment.rar.xml.JonasActivationspec;


/**
 * This class defines the implementation of the element jonas-activationspec
 *
 * @author Eric Hardesty
 */

public class JonasActivationspecDesc implements Serializable {

    /**
     * id
     */
    private String id = null;

    /**
     * description
     */ 
    private List descriptionList = null;

    /**
     * jndi-name
     */
    private String jndiName = null;

    /**
     * defaultAS
     */
    private String defaultAS = null;

    /**
     * Constructor
     */
    public JonasActivationspecDesc(JonasActivationspec ja) {
        if (ja != null) {
            id = ja.getId();
            descriptionList = ja.getDescriptionList();
            jndiName = ja.getJndiName();
            defaultAS = ja.getDefaultAS();
        }
    }

    /**
     * Gets the id
     * @return the id
     */
    public String getId() {
        return id;
    }

    /** 
     * Gets the description
     * @return the description
     */
    public List getDescriptionList() {
        return descriptionList;
    }

    /**
     * Gets the jndiname
     * @return the jndiname
     */
    public String getJndiName() {
        return jndiName;
    }

    /**
     * Gets the defaultAS
     * @return the defaultAS
     */
    public String getDefaultAS() {
        return defaultAS;
    }

}
