/**
 * JOnAS: Java(TM) Open Application Server
 * Copyright (C) 2009 Bull S.A.S.
 * Contact: jonas-team@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: JAXWSService.java 16705 2009-03-03 15:55:44Z sauthieg $
 * --------------------------------------------------------------------------
 */

package org.ow2.jonas.ws.jaxws.base;

import org.ow2.jonas.jmx.JmxService;
import org.ow2.jonas.lib.service.AbsServiceImpl;
import org.ow2.jonas.lib.util.JonasObjectName;
import org.ow2.jonas.service.ServiceException;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/**
 * Common abstract class for JAX-WS service implementations.
 * @author Francois Fornaciari
 */
public abstract class JAXWSService extends AbsServiceImpl implements JAXWSServiceMBean {

    /**
     * Logger.
     */
    private static Log logger = LogFactory.getLog(JAXWSService.class);

    /**
     * JMX Service reference.
     */
    private JmxService jmxService = null;

    /**
     * Starts the JAX-WS service.
     * @throws ServiceException If the service startup fails
     */
    @Override
    protected void doStart() throws ServiceException {
        // Register JAXWSService MBean
        try {
            jmxService.registerMBean(this, JonasObjectName.jaxwsService(getDomainName()));
        } catch (Exception e) {
            logger.warn("Cannot register MBean for JAX-WS service", e);
        }
    }

    /**
     * Stops the JAX-WS service.
     * @throws ServiceException If the service stop fails
     */
    @Override
    protected void doStop() throws ServiceException {
        if (jmxService != null) {
            // Unregister JAXWSService MBean
            try {
                jmxService.unregisterMBean(JonasObjectName.jaxwsService(getDomainName()));
            } catch (Exception e) {
                logger.debug("Cannot unregister MBean for JAX-WS service", e);
            }
        }
    }

    /**
     * @param jmxService the jmxService to set
     */
    public void setJmxService(final JmxService jmxService) {
        this.jmxService = jmxService;
    }

    /**
     * @return the jmxService
     */
    protected JmxService getJmxService() {
        return this.jmxService;
    }
}

