/**
 * JOnAS: Java(TM) Open Application Server
 * Copyright (C) 2009 Bull S.A.S.
 * Contact: jonas-team@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: PortIdentifier.java 16504 2009-02-12 17:26:21Z sauthieg $
 * --------------------------------------------------------------------------
 */

package org.ow2.jonas.ws.jaxws;

import javax.xml.namespace.QName;

/**
 * The PortIdentifier is the couple <code>wsdl:service</code> /
 * <code>wsdl:port</code> that identifies a port in a WSDL definition.
 *
 * @author Guillaume Sauthier
 */
public class PortIdentifier {

    /**
     * The <code>wsdl:service</code> name.
     */
    private QName serviceName;

    /**
     * The <code>wsdl:port</code> name.
     */
    private String portName;

    /**
     * Construct a new identifier.
     * @param serviceName <code>wsdl:service</code> name.
     * @param portName <code>wsdl:port</code> name.
     */
    public PortIdentifier(QName serviceName, String portName) {
        this.serviceName = serviceName;
        this.portName = portName;
    }

    /**
     * @return The <code>wsdl:service</code> name.
     */
    public QName getServiceName() {
        return serviceName;
    }

    /**
     * @return <code>wsdl:port</code> name.
     */
    public String getPortName() {
        return portName;
    }

    @Override
    public boolean equals(Object o) {
        // Generated by IDEA
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        PortIdentifier that = (PortIdentifier) o;

        if (portName != null ? !portName.equals(that.portName) : that.portName != null) return false;
        if (serviceName != null ? !serviceName.equals(that.serviceName) : that.serviceName != null) return false;

        return true;
    }

    @Override
    public int hashCode() {
        // Generated by IDEA
        int result = serviceName != null ? serviceName.hashCode() : 0;
        result = 31 * result + (portName != null ? portName.hashCode() : 0);
        return result;
    }
}
