/**
 * JOnAS: Java(TM) Open Application Server
 * Copyright (C) 20010 Bull S.A.
 * Contact: jonas-team@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: AddBean.java 19989 2010-06-17 14:48:20Z joaninh $
 * --------------------------------------------------------------------------
 */

package org.ow2.jonas.tests.applications.wsadd.beans;

import javax.ejb.Local;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import static javax.ejb.TransactionAttributeType.SUPPORTS;

import org.ow2.jonas.tests.applications.wsadd.api.IAddBean;


/**
 * Stateless Add.
 * @author Helene Joanin
 */
@Stateless
@Local(IAddBean.class)
public class AddBean implements IAddBean {

    /**
     * @return sum of the two args
     */
    @TransactionAttribute(SUPPORTS)
    public int addFromBean(int op1, int op2) {
        return (op1 + op2);
    }

}
