/**
 * JOnAS: Java(TM) Open Application Server
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: jonas-team@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: JaxWSAddTest.java 19991 2010-06-17 15:00:20Z joaninh $
 * --------------------------------------------------------------------------
 */
package org.ow2.jonas.itests.cargo.jrmp;

import java.lang.reflect.Method;
import java.net.URL;
import java.util.Random;

import org.testng.Assert;
import org.testng.annotations.Test;

import org.apache.cxf.endpoint.Client;
import org.apache.cxf.jaxws.endpoint.dynamic.JaxWsDynamicClientFactory;

/**
 * Tests the JAX-WS WSAdd service.
 */
public class JaxWSAddTest extends TestCommons {

    private String serviceURL;

    private URL wsdlURL;

    @Test
    public void waitForWSAddServiceInitialization() throws Exception {
        this.serviceURL = "http://localhost:" + this.webcontainerPort + "/wsadd-sample/WSAddService";
        this.wsdlURL = new URL(this.serviceURL + "?wsdl");

        final String expected = "http://wsadd.applis.tests.jonas.ow2.org/";

        String content = null;
        final long stopTime = System.currentTimeMillis() + TestCommons.TIMEOUT * 1000;
        while (System.currentTimeMillis() < stopTime) {
            Thread.sleep(1000);
            content = this.getContentAsString(this.wsdlURL);
            if (content.contains(expected)) {
                break;
            }
        }

        Assert.assertTrue(content.contains(expected), content + " does not contain " + expected);
    }


    @Test(dependsOnMethods = "waitForWSAddServiceInitialization")
    public void testWSAddService() throws Exception {
        final Random random = new Random(System.currentTimeMillis());
        final int op1 = random.nextInt();
        final int op2 = random.nextInt();

        JaxWsDynamicClientFactory dcf = JaxWsDynamicClientFactory.newInstance();
        Client client = dcf.createClient(this.wsdlURL);

        Object addRequest = Thread.currentThread().getContextClassLoader().loadClass("org.ow2.jonas.tests.applis.wsadd.AddRequest").newInstance();
        Method setOp1 = addRequest.getClass().getMethod("setOp1", Integer.TYPE);
        Method setOp2 = addRequest.getClass().getMethod("setOp2", Integer.TYPE);
        setOp1.invoke(addRequest, op1);
        setOp2.invoke(addRequest, op2);
        Object addResponse = client.invoke("add", addRequest)[0];

        Method getReturn = addResponse.getClass().getMethod("getReturn");
        String sresult = getReturn.invoke(addResponse).toString();
        int result = 0;
        try {
            result = Integer.parseInt(sresult);
        } catch (NumberFormatException e) {
            Assert.fail("did not get a add result value: " + sresult);
        }

        Assert.assertEquals(result, op1+op2, "add result incorrect: " + result + ", " + op1 + ", " + op2);

    }

    // uncomment the test to reproduce the Bug JIRA #213
    //@Test(dependsOnMethods = "waitForWSAddServiceInitialization")
    public void testEnvEntryInWSBug213() throws Exception {
        JaxWsDynamicClientFactory dcf = JaxWsDynamicClientFactory.newInstance();
        Client client = dcf.createClient(this.wsdlURL);

        Object checkResponse = client.invoke("checkEnvEntry")[0];

        Method getReturn = checkResponse.getClass().getMethod("getReturn");
        String sresult = getReturn.invoke(checkResponse).toString();
        boolean result = result = Boolean.valueOf(sresult);
        Assert.assertTrue(result, "Env-Entry  in WS-Pojo checking failed");

    }

    // uncomment the test to reproduce the Bug JIRA #215
    //@Test(dependsOnMethods = "waitForWSAddServiceInitialization")
    public void testEjbInWSBug215() throws Exception {
        JaxWsDynamicClientFactory dcf = JaxWsDynamicClientFactory.newInstance();
        Client client = dcf.createClient(this.wsdlURL);

        Object checkResponse = client.invoke("checkEjb")[0];

        Method getReturn = checkResponse.getClass().getMethod("getReturn");
        String sresult = getReturn.invoke(checkResponse).toString();
        boolean result = result = Boolean.valueOf(sresult);
        Assert.assertTrue(result, "@EJB in WS-Pojo checking failed");

    }

    // uncomment the test to reproduce the Bug JIRA #215
    //@Test(dependsOnMethods = "waitForWSAddServiceInitialization")
    public void testResourceInWSBug215() throws Exception {
        JaxWsDynamicClientFactory dcf = JaxWsDynamicClientFactory.newInstance();
        Client client = dcf.createClient(this.wsdlURL);

        Object checkResponse = client.invoke("checkResource")[0];

        Method getReturn = checkResponse.getClass().getMethod("getReturn");
        String sresult = getReturn.invoke(checkResponse).toString();
        boolean result = result = Boolean.valueOf(sresult);
        Assert.assertTrue(result, "@Resource in WS-Pojo checking failed");

    }

}
