/**
 * JOnAS: Java(TM) Open Application Server
 * Copyright (C) 2009 Bull S.A.S.
 * Contact: jonas-team@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 * --------------------------------------------------------------------------
 * $Id: OSGIContext.java 20796 2011-01-31 10:25:55Z benoitf $
 * --------------------------------------------------------------------------
 */

package org.ow2.jonas.web.tomcat6.osgi.httpservice;

import javax.servlet.ServletContext;

import org.osgi.framework.Bundle;
import org.osgi.service.http.HttpContext;
import org.ow2.jonas.web.tomcat6.JOnASStandardContext;

/**
 * {@link Context} implementation for holding OSGI servlet wrappers. Only the
 * {@link #getServletContext()} method is overridden.
 * @author Guillaume Porcher
 */
public class OSGIContext extends JOnASStandardContext {

    /**
     * Serial version UID.
     */
    private static final long serialVersionUID = -8093637123939061548L;

    /**
     * The {@link HttpContext} used during servlet or resource registration.
     */
    private final HttpContext httpContext;

    /**
     * The {@link Bundle} that uses the {@link HttpService}.
     */
    private final Bundle callerBundle;

    /**
     * Default constructor.
     * @param context The HttpContext used during servlet or resource
     *        registration.
     * @param callerBundle The bundle that uses the HttpService.
     */
    public OSGIContext(final HttpContext context, final Bundle callerBundle) {
        this.httpContext = context;
        this.callerBundle = callerBundle;
    }

    /**
     * Return the servlet context for which this Context is a facade. The
     * returned context is an instance of {@link OSGIServletContext}.
     * @return the servlet context for which this Context is a facade.
     */
    @Override
    public ServletContext getServletContext() {
        // Initialize if not yet done
        if (context == null) {
            this.context = new OSGIServletContext(this, this.httpContext);
        }
        return context;
    }

    /**
     * @return The httpContext used during servlet or resource registration.
     */
    public HttpContext getHttpContext() {
        return this.httpContext;
    }

    /**
     * @return The bundle that uses the service.
     */
    public Bundle getCallerBundle() {
        return this.callerBundle;
    }

}
