/**
 * JOnAS: Java(TM) Open Application Server
 * Copyright (C) 2009 Bull S.A.S.
 * Contact: jonas-team@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: ServiceContextNamingStrategy.java 16955 2009-03-23 15:17:41Z sauthieg $
 * --------------------------------------------------------------------------
 */

package org.ow2.jonas.web.tomcat6.ws.strategy;

import javax.xml.namespace.QName;

import org.ow2.jonas.ws.jaxws.ejb.context.IContextNamingStrategy;
import org.ow2.jonas.ws.jaxws.ejb.context.ContextNamingStrategyException;
import org.ow2.jonas.ws.jaxws.ejb.context.IContextNamingInfo;

/**
 * The ServiceContextNamingStrategy computes a web context name based
 * on the Service QName of the endpoint.
 *
 * @author Guillaume Sauthier
 */
public class ServiceContextNamingStrategy implements IContextNamingStrategy {

    /**
     * Creates a context name (web server root / context root).
     *
     * @param info used to determine the context name.
     * @return a context name
     */
    public String getContextName(final IContextNamingInfo info) throws ContextNamingStrategyException {
        QName name = info.getEndpoint().getIdentifier().getServiceName();
        if (name == null) {
            throw new ContextNamingStrategyException("Missing serviceName value.");
        }
        return name.getLocalPart();
    }
}
