/**
 * JOnAS: Java(TM) Open Application Server
 * Copyright (C) 2008-2009 Bull S.A.S.
 * Contact: jonas-team@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: EasyBeansJaxWsServerFactoryBean.java 19377 2010-03-08 09:49:45Z alitokmen $
 * --------------------------------------------------------------------------
 */

package org.ow2.jonas.ws.cxf.easybeans;

import java.lang.reflect.Method;
import java.rmi.RemoteException;

import javax.ejb.EJBException;
import javax.ejb.SessionBean;

import org.apache.cxf.jaxws.JAXWSMethodInvoker;
import org.apache.cxf.jaxws.JaxWsServerFactoryBean;
import org.apache.cxf.jaxws.support.JaxWsServiceFactoryBean;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.invoker.Factory;
import org.apache.cxf.service.invoker.Invoker;
import org.ow2.easybeans.api.bean.EasyBeansSLSB;
import org.ow2.easybeans.api.bean.info.IWebServiceInfo;
import org.ow2.easybeans.container.session.stateless.StatelessSessionFactory;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.pool.api.PoolException;
import org.ow2.util.ee.metadata.common.api.xml.struct.IHandlerChains;
import org.ow2.jonas.ws.cxf.JOnASJaxWsServerFactoryBean;
import org.ow2.jonas.ws.jaxws.handler.builder.DescriptorHandlerChainBuilder;

/**
 * Extended {@link JaxWsServerFactoryBean} to inhibit the resource injection.
 * This is done because we (EasyBeans) want to control resource injection.
 * @author Guillaume Sauthier
 */
public class EasyBeansJaxWsServerFactoryBean extends JOnASJaxWsServerFactoryBean {

    /**
     * EJB Factory.
     */
    private StatelessSessionFactory factory;

    /**
     * Delagating constructor.
     * @param serviceFactory Factory for {@link Service} instances.
     * @param factory EasyBeans EJB Factory
     */
    public EasyBeansJaxWsServerFactoryBean(final JaxWsServiceFactoryBean serviceFactory,
                                           final StatelessSessionFactory factory) {
        super(serviceFactory);
        this.factory = factory;

        // Check if we have a handlerChain defined in descriptor
        IWebServiceInfo info = factory.getSessionBeanInfo().getWebServiceInfo();
        if (info != null && (info.getHandlerChains() != null)) {

            // OK, a HandlerChain have been specified, use it ...
            IHandlerChains handlerChains = info.getHandlerChains();
            setHandlerChainBuilder(new DescriptorHandlerChainBuilder(handlerChains));
        }

    }

    /**
     * Overrided with no-op because we want to control injection.
     * @param instance unused
     * @see org.apache.cxf.jaxws.JaxWsServerFactoryBean#injectResources(java.lang.Object)
     */
    @Override
    protected void injectResources(final Object instance) {
        // Do nothing (Don't worry, that's OK :) )
    }

    /**
     * Set our own {@link Invoker}.
     * @see org.apache.cxf.jaxws.JaxWsServerFactoryBean#createInvoker()
     */
    @Override
    protected Invoker createInvoker() {
        return new EasyBeansMethodInvoker(new EasyBeansInvokerFactory(factory));
    }

    /**
     * @return the real Bean class.
     * @see org.apache.cxf.frontend.ServerFactoryBean#getServiceBeanClass()
     */
    @Override
    public Class<?> getServiceBeanClass() {
        return this.factory.getBeanClass();
    }
}

