/**
 * JOnAS: Java(TM) Open Application Server
 * Copyright (C) 2009 Bull S.A.S.
 * Contact: jonas-team@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: ServletRequestAdapterForTest.java 19283 2010-02-24 16:16:26Z benoitf $
 * --------------------------------------------------------------------------
 */
package org.ow2.jonas.ws.jaxws.http.servlet.test;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URL;
import java.security.Principal;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import org.ow2.jonas.ws.jaxws.IWSRequest;

public class ServletRequestAdapterForTest implements IWSRequest,HttpServletRequest {

    private int contentLength;

    private String contentType;

    private ServletInputStream in;

    private String method;

    private Map parameters;

    private URI uri;

    private URL url;

    private Map headers;

    private Map attributes;

    private String remoteAddress;

    private String queryString;

    public ServletRequestAdapterForTest(final int contentLength, final String contentType, final ServletInputStream in,
            final String method, final Map parameters, final URI uri,final URL url, final String queryString,final Map headers,
            final String remoteAddress) {
        this.contentType = contentType;
        this.in = in;
        this.method = method;
        this.parameters = parameters;
        this.uri = uri;
        this.headers = headers;
        this.attributes = new HashMap();
        this.remoteAddress = remoteAddress;
        this.url = url;
        this.queryString = queryString;
    }

    public <T> T getAttribute(final Class<T> type) {
        return type.cast(attributes.get(type));
    }

    public String getContentType() {
        // TODO Auto-generated method stub
        return contentType;
    }

    public String getHeader(final String name) {
        // TODO Auto-generated method stub
        return (String) headers.get(name);
    }

    public ServletInputStream getInputStream() throws IOException {
        // TODO Auto-generated method stub
        return in;
    }

    public String getRemoteAddr() {
        // TODO Auto-generated method stub
        return remoteAddress;
    }

    public <T> T setAttribute(final Class<T> type, final T value) {
        Object old = attributes.put(type, value);
        return type.cast(old);
    }

    public String getAuthType() {
        // TODO Auto-generated method stub
        return null;
    }

    public String getContextPath() {
        // TODO Auto-generated method stub
        return null;
    }

    public Cookie[] getCookies() {
        // TODO Auto-generated method stub
        return null;
    }

    public long getDateHeader(final String arg0) {
        // TODO Auto-generated method stub
        return 0;
    }

    public Enumeration getHeaderNames() {
        // TODO Auto-generated method stub
        return null;
    }

    public Enumeration getHeaders(final String arg0) {
        // TODO Auto-generated method stub
        return null;
    }

    public int getIntHeader(final String arg0) {
        // TODO Auto-generated method stub
        return 0;
    }

    public String getMethod() {
        // TODO Auto-generated method stub
        return method;
    }

    public String getPathInfo() {
        // TODO Auto-generated method stub
        return null;
    }

    public String getPathTranslated() {
        // TODO Auto-generated method stub
        return null;
    }

    public String getQueryString() {
        // TODO Auto-generated method stub
        return queryString;
    }

    public String getRemoteUser() {
        // TODO Auto-generated method stub
        return null;
    }

    public String getRequestURI() {
        // TODO Auto-generated method stub
        return uri.toString();
    }

    public StringBuffer getRequestURL() {
        // TODO Auto-generated method stub
        return new StringBuffer(url.toString());
    }

    public String getRequestedSessionId() {
        // TODO Auto-generated method stub
        return null;
    }

    public String getServletPath() {
        // TODO Auto-generated method stub
        return null;
    }

    public HttpSession getSession() {
        // TODO Auto-generated method stub
        return null;
    }

    public HttpSession getSession(final boolean arg0) {
        // TODO Auto-generated method stub
        return null;
    }

    public Principal getUserPrincipal() {
        // TODO Auto-generated method stub
        return null;
    }

    public boolean isRequestedSessionIdFromCookie() {
        // TODO Auto-generated method stub
        return false;
    }

    public boolean isRequestedSessionIdFromURL() {
        // TODO Auto-generated method stub
        return false;
    }

    public boolean isRequestedSessionIdFromUrl() {
        // TODO Auto-generated method stub
        return false;
    }

    public boolean isRequestedSessionIdValid() {
        // TODO Auto-generated method stub
        return false;
    }

    public boolean isUserInRole(final String arg0) {
        // TODO Auto-generated method stub
        return false;
    }

    public Object getAttribute(final String arg0) {
        // TODO Auto-generated method stub
        return null;
    }

    public Enumeration getAttributeNames() {
        // TODO Auto-generated method stub
        return null;
    }

    public String getCharacterEncoding() {
        // TODO Auto-generated method stub
        return null;
    }

    public int getContentLength() {
        // TODO Auto-generated method stub
        return contentLength;
    }

    public String getLocalAddr() {
        // TODO Auto-generated method stub
        return null;
    }

    public String getLocalName() {
        // TODO Auto-generated method stub
        return null;
    }

    public int getLocalPort() {
        // TODO Auto-generated method stub
        return 0;
    }

    public Locale getLocale() {
        // TODO Auto-generated method stub
        return null;
    }

    public Enumeration getLocales() {
        // TODO Auto-generated method stub
        return null;
    }

    public String getParameter(final String arg0) {
        // TODO Auto-generated method stub
        return null;
    }

    public Map getParameterMap() {
        // TODO Auto-generated method stub
        return null;
    }

    public Enumeration getParameterNames() {
        // TODO Auto-generated method stub
        return null;
    }

    public String[] getParameterValues(final String arg0) {
        // TODO Auto-generated method stub
        return null;
    }

    public String getProtocol() {
        // TODO Auto-generated method stub
        return null;
    }

    public BufferedReader getReader() throws IOException {
        // TODO Auto-generated method stub
        return null;
    }

    public String getRealPath(final String arg0) {
        // TODO Auto-generated method stub
        return null;
    }

    public String getRemoteHost() {
        // TODO Auto-generated method stub
        return null;
    }

    public int getRemotePort() {
        // TODO Auto-generated method stub
        return 0;
    }

    public RequestDispatcher getRequestDispatcher(final String arg0) {
        // TODO Auto-generated method stub
        return null;
    }

    public String getScheme() {
        // TODO Auto-generated method stub
        return null;
    }

    public String getServerName() {
        // TODO Auto-generated method stub
        return null;
    }

    public int getServerPort() {
        // TODO Auto-generated method stub
        return 0;
    }

    public boolean isSecure() {
        // TODO Auto-generated method stub
        return false;
    }

    public void removeAttribute(final String arg0) {
        // TODO Auto-generated method stub

    }

    public void setAttribute(final String arg0, final Object arg1) {
        // TODO Auto-generated method stub

    }

    public void setCharacterEncoding(final String arg0) throws UnsupportedEncodingException {
        // TODO Auto-generated method stub

    }
}
