/**
 * JOnAS: Java(TM) Open Application Server
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: jonas-team@ow2.org
 *
 * Application Versioning System
 * Copyright (C) 2008 France Telecom R&D
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: EmptyServlet.java 20235 2010-08-31 16:07:08Z alitokmen $
 * --------------------------------------------------------------------------
 */
package org.ow2.jonas.web.tomcat7.versioning;

import java.io.IOException;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;

/**
 * Empty servlet.
 *
 * @author S. Ali Tokmen
 */
public class EmptyServlet implements Servlet {

    private ServletConfig sc;

    @Override
    public void init(ServletConfig sc) throws ServletException {
        this.sc = sc;
    }

    @Override
    public ServletConfig getServletConfig() {
        return this.sc;
    }

    @Override
    public void service(ServletRequest request, ServletResponse rsp) throws ServletException, IOException {
        HttpServletResponse response = (HttpServletResponse) rsp;
        response.setStatus(404);
    }

    @Override
    public String getServletInfo() {
        return this.toString() + "[" + this.sc + "]";
    }

    @Override
    public void destroy() {
        // Nothing
    }

}
