/**
 * JOnAS: Java(TM) Open Application Server
 * Copyright (C) 1999-2004 Bull S.A.
 * Contact: jonas-team@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: JOnASServiceImplWriter.java 15428 2008-10-07 11:20:29Z sauthieg $
 * --------------------------------------------------------------------------
 */
package org.ow2.jonas.generators.wsgen.generator.axis.wsdl2java;

import org.apache.axis.wsdl.symbolTable.ServiceEntry;
import org.apache.axis.wsdl.symbolTable.SymbolTable;
import org.apache.axis.wsdl.toJava.Emitter;
import org.apache.axis.wsdl.toJava.JavaServiceImplWriter;


/**
 * ServiceImplWriter that substitues Axis' Service implementation with our own.
 *
 * @author Guillaume Sauthier
 */
public class JOnASServiceImplWriter extends JavaServiceImplWriter {

    /**
     * Constructor.
     *
     * @param emitter JOnASEmitter
     * @param sEntry ServiceEntry
     * @param symbolTable SymbolTable
     */
    public JOnASServiceImplWriter(Emitter emitter, ServiceEntry sEntry, SymbolTable symbolTable) {
        super(emitter, sEntry, symbolTable);
    }

    /**
     * @return Returns "extends org.ow2.jonas.ws.axis.JService ".
     */
    protected String getExtendsText() {
        return "extends org.ow2.jonas.ws.axis.JService ";
        //return "extends org.apache.axis.client.Service ";
    }    // getExtendsText


}
