/**
 * JOnAS: Java(TM) Open Application Server
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: jonas-team@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 * --------------------------------------------------------------------------
 * $Id: MockBeanDeploymentArchive.java 19316 2010-03-02 16:24:45Z sauthieg $
 * --------------------------------------------------------------------------
 */


package org.ow2.jonas.cdi.weld.internal.mock;

import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;

import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.ejb.spi.EjbDescriptor;

/**
 * A {@code MockBeanDeploymentArchive} is ...
 *
 * @author Guillaume Sauthier
 */
public class MockBeanDeploymentArchive implements BeanDeploymentArchive {

    private Collection<BeanDeploymentArchive> archives;
    private Collection<Class<?>> classes;
    private Collection<URL> beansXml;
    private String id;

    public MockBeanDeploymentArchive(String id) {
        this.id = id;
        this.archives = new HashSet<BeanDeploymentArchive>();
        this.classes = new HashSet<Class<?>>();
        this.beansXml = new HashSet<URL>();
    }

    public Collection<BeanDeploymentArchive> getBeanDeploymentArchives() {
        return archives;
    }

    public Collection<Class<?>> getBeanClasses() {
        return classes;
    }

    public Collection<URL> getBeansXml() {
        return beansXml;
    }

    public Collection<EjbDescriptor<?>> getEjbs() {
        return null;
    }

    public ServiceRegistry getServices() {
        return null;
    }

    public String getId() {
        return id;
    }
}
