/**
 * JOnAS: Java(TM) Open Application Server
 * Copyright (C) 2011 Bull S.A.S.
 * Contact: jonas-team@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 * --------------------------------------------------------------------------
 * $Id: JaxwsAuditReport.java 21004 2011-03-16 12:34:11Z sauthieg $
 * --------------------------------------------------------------------------
 */


package org.ow2.jonas.ws.jaxws.base.audit;

import java.util.Set;

import org.ow2.util.auditreport.impl.GenericAuditReport;

/**
 * A {@code JaxwsAuditReport} is ...
 *
 * @author Guillaume Sauthier
 */
public class JaxwsAuditReport extends GenericAuditReport {

    private String serviceQName;
    private String portQName;
    private String operationQName;
    private Set<String> soapRoles;
    private long endProcessingTimestamp;

    public Set<String> getSoapRoles() {
        return soapRoles;
    }

    public void setSoapRoles(Set<String> roles) {
        this.soapRoles = roles;
    }

    public String getServiceQName() {
        return serviceQName;
    }

    public void setServiceQName(String service) {
        this.serviceQName = service;
    }

    public String getPortQName() {
        return portQName;
    }

    public void setPortQName(String port) {
        this.portQName = port;
    }

    public String getOperationQName() {
        return operationQName;
    }

    public void setOperationQName(String operation) {
        this.operationQName = operation;
    }

    public void setEndProcessingTimestamp(long endProcessingTimestamp) {
        this.endProcessingTimestamp = endProcessingTimestamp;
    }

    public long getEndProcessingTimestamp() {
        return endProcessingTimestamp;
    }
}
