/**
 * JOnAS: Java(TM) Open Application Server
 * Copyright (C) 1999 Bull S.A.
 * Contact: jonas-team@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: EditServletServerAction.java 15428 2008-10-07 11:20:29Z sauthieg $
 * --------------------------------------------------------------------------
 */

package org.ow2.jonas.webapp.jonasadmin.jonasserver;

import java.io.IOException;

import javax.management.ObjectName;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.ow2.jonas.lib.util.JonasObjectName;
import org.ow2.jonas.webapp.jonasadmin.JonasBaseAction;

import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;


/**
 * @author Michel-Ange ANTON
 */

public class EditServletServerAction extends JonasBaseAction {

// --------------------------------------------------------- Public Methods
    /**
     * Execute action for servlet server management
     * @param pMapping mapping info
     * @param pForm form object
     * @param pRequest HTTP request
     * @param pResponse HTTP response
     *
     * @return An <code>ActionForward</code> instance or <code>null</code>
     *
     * @exception IOException if an input/output error occurs
     * @exception ServletException if a servlet exception occurs
     */
    public ActionForward executeAction(ActionMapping pMapping, ActionForm pForm
        , HttpServletRequest pRequest, HttpServletResponse pResponse)
        throws IOException, ServletException {

        // Force the node selected in tree
        m_WhereAreYou.selectNameNode(getTreeBranchName(DEPTH_SERVER), true);
        String domainName = m_WhereAreYou.getCurrentDomainName();
        // Form used
        ServletServerForm oForm = new ServletServerForm();
        pRequest.setAttribute("servletServerForm", oForm);
        try {
            // Object name used
            ObjectName oObjectName = JonasObjectName.webContainerService(domainName);
            oForm.setServerName(getStringAttribute(oObjectName, "ServerName"));
            oForm.setServerVersion(getStringAttribute(oObjectName, "ServerVersion"));
            if (m_WhereAreYou.isCatalinaServer()) {
                oForm.setServerCatalina(true);
                oForm.setServerCatalinaService(m_WhereAreYou.getCurrentCatalinaServiceName());
                oForm.setServerCatalinaEngine(m_WhereAreYou.getCurrentCatalinaEngineName());
                oForm.setServerCatalinaDefaultHost(m_WhereAreYou.getCurrentCatalinaDefaultHostName());

                // Get the forward parameter in query string or in http request
                String sForward = pRequest.getParameter("forward");
                if (sForward == null) {
                    sForward = (String) pRequest.getAttribute("forward");
                }
                oForm.setForwardAfter(sForward);
            }
        } catch (Throwable t) {
            addGlobalError(t);
            saveErrors(pRequest, m_Errors);
            return (pMapping.findForward("Global Error"));
        }
        // Forward to the jsp.
        return (pMapping.findForward("Servlet Server"));
    }

}
