/**
 * JOnAS: Java(TM) Open Application Server
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: jonas-team@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 * --------------------------------------------------------------------------
 * $Id: IDeploymentBuilder.java 19316 2010-03-02 16:24:45Z sauthieg $
 * --------------------------------------------------------------------------
 */

package org.ow2.jonas.cdi.weld;

import org.jboss.weld.bootstrap.spi.Deployment;
import org.ow2.util.archive.api.IArchive;

/**
 * A {@code IDeploymentBuilder} is used to construct a Weld {@link Deployment}
 * instance from an archive.
 *
 * @author Guillaume Sauthier
 */
public interface IDeploymentBuilder {

    /**
     * Build a Web related {@code Deployment} archive.
     * @param archive a web archive
     * @return a Weld configured {@code Deployment} instance.
     */
    Deployment buildWebDeployment(IArchive archive);
}
