/**
 * JOnAS: Java(TM) Open Application Server
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: jonas-team@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 * --------------------------------------------------------------------------
 * $Id: IWeldService.java 19316 2010-03-02 16:24:45Z sauthieg $
 * --------------------------------------------------------------------------
 */

package org.ow2.jonas.cdi.weld;

import java.util.Collection;

import org.jboss.weld.bootstrap.api.Bootstrap;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.bootstrap.spi.Deployment;
import org.ow2.util.archive.api.IArchive;

/**
 * A {@code IWeldService} is some kind of utility service that takes care of Weld related
 * operations.
 *
 * @author Guillaume Sauthier
 */
public interface IWeldService {

    /**
     * Detect if the given {@code IArchive} contains a {@code beans.xml}.
     * Checked location includes:
     * <ul>
     *   <li>{@code WEB-INF/beans.xml}</li>
     *   <li>{@code META-INF/beans.xml}</li>
     * </ul>
     * @param archive explored archive
     * @return {@code true} if the given archive is CDI enabled, {@code false} otherwise.
     */
    boolean isCdiEnabled(IArchive archive);

    /**
     * Connects all the BDA in the first Collection to each BDA in the second Collection.
     * That makes beans from the second Collection (aka parent) accessible from the beans
     * defined in the first Collection (childs).
     * @param childs Collection of BDAs
     * @param parents Collection of BDAs that will be accessibles from childs
     */
    void connectBeanDeploymentArchives(Collection<BeanDeploymentArchive> childs,
                                       Collection<BeanDeploymentArchive> parents);

    /**
     * Starts a Weld container from a given Weld {@code Deployment}.
     * @param deployment Weld deployment interface
     * @return a started Weld Bootstrap
     */
    Bootstrap startWeldContainer(Deployment deployment);
}
