/**
 * JOnAS: Java(TM) Open Application Server
 * Copyright (C) 2009 Bull S.A.S.
 * Contact: jonas-team@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 * --------------------------------------------------------------------------
 * $Id: HttpServiceFactory.java 19326 2010-03-03 10:50:55Z alitokmen $
 * --------------------------------------------------------------------------
 */

package org.ow2.jonas.web.tomcat6.osgi.httpservice;

import org.osgi.framework.Bundle;
import org.ow2.jonas.web.base.osgi.httpservice.JOnASHttpService;
import org.ow2.jonas.web.tomcat6.Tomcat6Service;

/**
 * Service factory for Tomcat6 service.
 * @author Florent Benoit
 */
public class HttpServiceFactory extends org.ow2.jonas.web.base.osgi.httpservice.HttpServiceFactory<Tomcat6Service> {

    /**
     * Constructor.
     * @param tomcat6Service the web container service to use.
     */
    public HttpServiceFactory(final Tomcat6Service tomcat6Service) {
        super(tomcat6Service);
    }

    /**
     * Build an implementation of the Http service.
     * @param callerBundle The bundle using the service.
     * @param tomcat6Service the web container service instance
     * @return an implementation of the httpService
     */
    @Override
    protected JOnASHttpService buildHttpServiceImpl(final Bundle callerBundle, final Tomcat6Service tomcat6Service) {
        return new HttpServiceImpl(callerBundle, tomcat6Service, getWorkDirectory());
    }

}
