/**
 * JOnAS: Java(TM) Open Application Server
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: jonas-team@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 * --------------------------------------------------------------------------
 * $Id: IDatasourceXmlReader.java 20342 2010-09-17 12:34:43Z pelletib $
 * --------------------------------------------------------------------------
 */

package org.ow2.jonas.datasource.reader;

import java.io.File;
import java.util.Properties;

import javax.xml.bind.JAXBException;

import org.ow2.jonas.datasource.binding.DatasourceType;
import org.ow2.jonas.datasource.binding.Datasources;

/**
 * This is the interface which enable different operation on a XML file.
 * @author Rodrigue SOUBEIGA
 */
public interface IDatasourceXmlReader {

    /**
     * Initializes a DatasourceType object.
     * @param dataSource which must be initialized.
     * @return a DatasourceType object which is initialized
     */
    DatasourceType initDataSource(DatasourceType dataSource);

    /**
     * Returns a boolean which allows to know if the XML file is valid.
     * @param xmlFile the XML file to analyze.
     * @return a boolean which is true iff the XML file is valid.
     */
    boolean isXmlValid(File xmlFile);

    /**
     * Returns an list of datasourceType from an XML file.
     * @param xmlFile the XML file which must be convert to java objects.
     * @return a list of datasourceType
     * @throws JAXBException if a problem occurs while creating the list of
     *         DatasourceType objects
     */
    Datasources extractDataSources(File xmlFile) throws JAXBException;

    /**
     * Converts a datasourceType object to a Properties object.
     * @param datasource the DatasourceType object to convert.
     * @return a Properties object from the conversion of a datasourceType
     *         object.
     */
    Properties getProperties(final DatasourceType datasource);

}
