/**
 * JOnAS: Java(TM) Open Application Server
 * Copyright (C) 1999-2004 Bull S.A.
 * Contact: jonas-team@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * Initial developer: Florent BENOIT
 * --------------------------------------------------------------------------
 * $Id: JPrincipal.java 15428 2008-10-07 11:20:29Z sauthieg $
 * --------------------------------------------------------------------------
 */

package org.ow2.jonas.lib.security.auth;

import java.io.Serializable;
import java.security.Principal;

/**
 * Define a JOnAS principal
 * @author Florent Benoit
 */
public class JPrincipal implements Principal, Serializable {


    /**
     * Name of this principal
     */
    private String name = null;

    /**
     * Constructor
     * @param name the name of this principal
     */
    public JPrincipal(String name) {
        this.name = name;
    }

    /**
     * Compares this principal to the specified object. Returns true if the object passed in matches the principal represented by the implementation of this interface.
     * @param another principal to compare with.
     * @return true if the principal passed in is the same as that encapsulated by this principal, and false otherwise.
     */
    public boolean equals(Object another) {
        if (!(another instanceof Principal)) {
            return false;
        }
        // else
        return name.equals(((Principal) another).getName());
    }

    /**
     * Returns a string representation of this principal.
     * @return a string representation of this principal.
     */
    public String toString() {
        return "Principal[" + name + "]";
    }


    /**
     * Returns a hashcode for this principal.
     * @return a hashcode for this principal.
     */
    public int hashCode() {
        return name.hashCode();
    }

    /**
     * Returns the name of this principal.
     * @return the name of this principal.
     */
    public String getName() {
        return name;
    }




}
