/**
 * JOnAS: Java(TM) Open Application Server
 * Copyright (C) 2008 Bull S.A.S.
 * Contact: jonas-team@ow2.org
 *
 * Application Versioning System
 * Copyright (C) 2008 France Telecom R&D
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: WebModuleContext.java 18470 2009-09-02 15:23:42Z alitokmen $
 * --------------------------------------------------------------------------
 */

package org.ow2.jonas.web.tomcat6.versioning;

import java.net.URL;

import javax.naming.directory.DirContext;

import org.apache.catalina.Context;

/**
 * Interface that lists all method that a management bean that Tomcat should
 * recognize as a WebModule.
 * @author Frederic Germaneau
 * @author S. Ali Tokmen
 */
public interface WebModuleContext {

    /**
     * @return The mapping context, can be null.
     */
    Context findMappingObject();

    /**
     * @return Static resources, can be null.
     */
    DirContext findStaticResources();

    /**
     * @return Welcome files for the web application's directories.
     */
    String[] getwelcomeFiles();

    /**
     * @return URL of the WAR file.
     */
    URL getwarURL();

}
