/**
 * JOnAS: Java(TM) Open Application Server
 * Copyright (C) 2008 Bull S.A.S.
 * Contact: jonas-team@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: IPersistenceUnitRefDesc.java 16097 2008-12-18 16:51:34Z danesa $
 * --------------------------------------------------------------------------
 */

package org.ow2.jonas.deployment.api;

/**
 * Interface for persistence-unit-ref elements in J2EE deployment descriptors.
 */
public interface IPersistenceUnitRefDesc {

    /**
     * Get the persistence unit reference name.
     * @return persistence unit reference name
     */
    String getRefName();

    /**
     * Get the optional persistence unit name.
     * @return persistence unit name
     */
    String getName();

    /**
     * Get the optional description.
     * @return persistence unit reference description
     */
    String getDescription();
}
