/**
 * JOnAS: Java(TM) Open Application Server
 * Copyright (C) 2011 Bull S.A.S.
 * Contact: jonas-team@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 * --------------------------------------------------------------------------
 * $Id: AuditPropagationServlet.java 21050 2011-03-24 14:43:27Z benoitf $
 * --------------------------------------------------------------------------
 */


package org.ow2.jonas.tests.applications.wsadd.ws;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.ow2.util.auditreport.api.IAuditID;
import org.ow2.util.auditreport.impl.CurrentInvocationID;

/**
 * A {@code AuditPropagationServlet} is ...
 *
 * @author Guillaume Sauthier
 */
public class AuditPropagationServlet extends HttpServlet {
    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {

        // The Audit ID should be installed in the ThreadLocal now ...
        IAuditID id = CurrentInvocationID.getInstance().getAuditID();
        String result = "null";
        if (id != null) {
            result = id.getID();
        }

        // Print back the result
        resp.getWriter().println(result);
    }
}
