/**
 * JOnAS: Java(TM) Open Application Server
 * Copyright (C) 1999 Bull S.A.
 * Contact: jonas-team@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: ListMailFactoriesAction.java 15428 2008-10-07 11:20:29Z sauthieg $
 * --------------------------------------------------------------------------
 */

package org.ow2.jonas.webapp.jonasadmin.resource;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.ow2.jonas.webapp.jonasadmin.JonasAdminJmx;
import org.ow2.jonas.webapp.jonasadmin.JonasBaseAction;

import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

/**
 *
 */

public class ListMailFactoriesAction extends JonasBaseAction {

// --------------------------------------------------------- Public Methods

    /**
     */
    public ActionForward executeAction(ActionMapping p_Mapping, ActionForm p_Form
        , HttpServletRequest p_Request, HttpServletResponse p_Response)
        throws IOException, ServletException {

        // Current server
        String serverName = m_WhereAreYou.getCurrentJonasServerName();
        String domainName = m_WhereAreYou.getCurrentDomainName();

        // no Form used
        try {
            ArrayList alSessionDeployable = JonasAdminJmx.getSessionMailFilesDeployable(domainName, serverName);
            ArrayList alMimePartDeployable = JonasAdminJmx.getMimePartMailFilesDeployable(domainName, serverName);
            ArrayList alDeployed = JonasAdminJmx.getMailFilesDeployed(m_WhereAreYou);

            ArrayList al = new ArrayList();
            String sName;
            boolean bDeployed;
            Iterator it = alSessionDeployable.iterator();
            while (it.hasNext()) {
                sName = it.next().toString();
                bDeployed = alDeployed.contains(sName);
                al.add(new MailFactoryItem(sName, bDeployed, "session"));
            }
            it = alMimePartDeployable.iterator();
            while (it.hasNext()) {
                sName = it.next().toString();
                bDeployed = alDeployed.contains(sName);
                al.add(new MailFactoryItem(sName, bDeployed, "mimepart"));
            }
            //Collections.sort(al, new DatasourceItemByNameComparator());
            // Set list in the request
            p_Request.setAttribute("listMailFactories", al);
        }
        catch (Throwable t) {
            addGlobalError(t);
            saveErrors(p_Request, m_Errors);
            return (p_Mapping.findForward("Global Error"));
        }
        // Forward to the jsp.
        return (p_Mapping.findForward("MailFactories"));
    }
}
