/**
 * JOnAS: Java(TM) Open Application Server
 * Copyright (C) 1999-2007 Bull S.A.S.
 * Contact: jonas-team@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id:IConfigurationActuator.java 10753 2007-06-26 13:39:43Z durieuxp $
 * --------------------------------------------------------------------------
 */

package org.ow2.jonas.lib.management.reconfig;



/**
 * This interface is designed for a reconfigurator for xml or properties file.
 * @author Adriana Danes
 * @author Florent Benoit : Add an abstract class to define XMLConfigurationActuator in addition to PropertiesConfigurationActuator
 */
public interface IConfigurationActuator {

    /**
     * Saves the updated configuration
     * @param sequence the sequence number of management notification producing the save (in fact store) operation
     * @throws ReconfigException if the saveConfig could not be done
     */
    void saveConfig(long sequence) throws ReconfigException;
}
