/**
 * JOnAS: Java(TM) Open Application Server
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: jonas-team@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 * --------------------------------------------------------------------------
 * $Id: DefaultDeployment.java 19316 2010-03-02 16:24:45Z sauthieg $
 * --------------------------------------------------------------------------
 */

package org.ow2.jonas.cdi.weld.internal.deployment;

import java.util.Collection;
import java.util.HashSet;

import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.bootstrap.api.helpers.SimpleServiceRegistry;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.bootstrap.spi.Deployment;

/**
 * A {@code DefaultDeployment} is a structure that contains a collection of BDAs.
 *
 * @author Guillaume Sauthier
 */
public class DefaultDeployment implements Deployment {

    /**
     * Contained BDAs.
     */
    private Collection<BeanDeploymentArchive> beanDeploymentArchives;

    /**
     * Service registry.
     */
    private ServiceRegistry registry;

    public DefaultDeployment() {
        beanDeploymentArchives = new HashSet<BeanDeploymentArchive>();
        registry = new SimpleServiceRegistry();
    }

    /**
     * Get the bean deployment archives which are part of this deployment
     * and adjacent to it in the deployment archive graph. This should include
     * all Java EE modules such as WARs, EJB jars and RARs.
     * <p/>
     * Cycles in the accessible BeanDeploymentArchive graph are allowed. If a
     * cycle is detected by Weld, it will be automatically removed by Web
     * Beans. This means any implementor of this interface don't need to worry
     * about circularities.
     *
     * @return the accessible bean deployment archives
     */
    public Collection<BeanDeploymentArchive> getBeanDeploymentArchives() {
        return beanDeploymentArchives;
    }

    /**
     * Load the {@link org.jboss.weld.bootstrap.spi.BeanDeploymentArchive} containing the given class.
     * <p/>
     * If the deployment archive containing the given class is not currently a
     * bean deployment archive, it must be added to the bean deployment archive
     * graph and returned. If the deployment archive is currently a bean
     * deployment archive it should be returned.
     * <p/>
     * If beanClass is the bean class of an EJB session bean, an {@link org.jboss.weld.ejb.spi.EjbDescriptor}
     * for the bean must be returned by {@link org.jboss.weld.bootstrap.spi.BeanDeploymentArchive#getEjbs()}.
     *
     * @param beanClass the bean class to load
     * @return the {@link org.jboss.weld.bootstrap.spi.BeanDeploymentArchive} containing the bean class
     */
    public BeanDeploymentArchive loadBeanDeploymentArchive(Class<?> beanClass) {
        // TODO to be implemented
        return null;
    }

    /**
     * Get the services available to this deployment
     *
     * @return the services available
     */
    public ServiceRegistry getServices() {
        return registry;
    }
}
