/**
 * JOnAS: Java(TM) Open Application Server
 * Copyright (C) 1999 Bull S.A.
 * Contact: jonas-team@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: ListServicesAction.java 16738 2009-03-05 14:53:39Z danesa $
 * --------------------------------------------------------------------------
 */

package org.ow2.jonas.webapp.jonasadmin.service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;

import javax.management.ObjectName;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.ow2.jonas.lib.management.extensions.base.JonasManagementRepr;
import org.ow2.jonas.lib.management.javaee.J2eeObjectName;
import org.ow2.jonas.webapp.jonasadmin.JonasBaseAction;
import org.ow2.jonas.webapp.jonasadmin.WhereAreYou;


/**
 * @author Michel-Ange ANTON
 */

public class ListServicesAction extends JonasBaseAction {

// --------------------------------------------------------- Public Methods

    @Override
    public ActionForward executeAction(final ActionMapping p_Mapping, final ActionForm p_Form
        , final HttpServletRequest p_Request, final HttpServletResponse p_Response)
        throws IOException, ServletException {

        // Force the node selected in tree
        m_WhereAreYou.selectNameNode(getTreeBranchName(DEPTH_SERVER) + WhereAreYou.NODE_SEPARATOR
            + "services", true);

        WhereAreYou oWhere = (WhereAreYou) p_Request.getSession().getAttribute(WhereAreYou.
                SESSION_NAME);
        String serverName = oWhere.getCurrentJonasServerName();
        String domainName = m_WhereAreYou.getCurrentDomainName();

        // Services list is provided by the J2EEServer MBean
        ObjectName on = J2eeObjectName.J2EEServer(domainName, serverName);

        // no Form used
        try {
            ArrayList al = new ArrayList();
            ArrayList contl = new ArrayList();
            ArrayList mandl = new ArrayList();
            ArrayList wsdl = new ArrayList();
            String[] services = (String[]) JonasManagementRepr.getAttribute(on, "services", serverName);
            for (int i = 0; i < services.length; i++) {
                String serviceName = services[i];
                ServiceItem item = getServerItem(serviceName);
                if (item != null) {
                    if (item.isContainer()) {
                        contl.add(item);
                    } else if (item.isMandatory()) {
                        mandl.add(item);
                    } else if (item.isWebservices()) {
                        wsdl.add(item);
                    } else {
                        al.add(item);
                    }
                }
            }
            // sort
            Collections.sort(contl, new ServiceItemByNameComparator());
            Collections.sort(mandl, new ServiceItemByNameComparator());
            Collections.sort(wsdl, new ServiceItemByNameComparator());
            Collections.sort(al, new ServiceItemByNameComparator());
            // Set lists in the session and not in the request because
            // if Stop/Start service action is executed, the Services
            // forward (services.jsp) needs these lists.
            m_Session.setAttribute("listServices", al);
            m_Session.setAttribute("contServices", contl);
            m_Session.setAttribute("wsServices", wsdl);
            m_Session.setAttribute("mandServices", mandl);
        } catch (Throwable t) {
            addGlobalError(t);
            saveErrors(p_Request, m_Errors);
            return (p_Mapping.findForward("Global Error"));
        }
        // Forward to the jsp.
        return (p_Mapping.findForward("Services"));
    }
}
