/**
 * JOnAS: Java(TM) Open Application Server
 * Copyright (C) 2011 Bull S.A.S.
 * Contact: jonas@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: ClusterDaemonApplication.java 21707 2011-09-07 09:44:45Z benoitf $
 * --------------------------------------------------------------------------
 */
package org.ow2.jonas.cluster.daemon.rest.impl;


import org.ow2.jonas.cluster.daemon.rest.impl.ClusterDaemon;

import javax.ws.rs.core.Application;
import java.util.HashSet;
import java.util.Set;


public class ClusterDaemonApplication extends Application {

    private org.ow2.jonas.cluster.daemon.api.IClusterDaemon clusterDaemon;

    public ClusterDaemonApplication(org.ow2.jonas.cluster.daemon.api.IClusterDaemon clusterDaemon){
        this.clusterDaemon = clusterDaemon;
    }

    /*@Override
    public Set<Class<?>> getClasses() {
        return null;
    }*/

    @Override
    public Set<Object> getSingletons() {
        Set<Object> objects = new HashSet<Object>();
        objects.add(new ClusterDaemon(clusterDaemon));
        return objects;
    }
}
