/*
 * JOnAS: Java(TM) Open Application Server
 * Copyright (C) 1999 Bull S.A.
 * Contact: jonas-team@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: OwnerMbeanItem.java 16123 2009-01-08 12:46:35Z eyindanga $
 * --------------------------------------------------------------------------
 */

package org.ow2.jonas.lib.management.extensions.base.mbean;

import javax.management.ObjectName;


/**
 * @author Michel-Ange ANTON
 */
public class OwnerMbeanItem extends MbeanItem {

// --------------------------------------------------------- Constants

// --------------------------------------------------------- Properties Variables

    private String type = null;

// --------------------------------------------------------- Constructors

    public OwnerMbeanItem() {
        super();
    }

    public OwnerMbeanItem(ObjectName p_ObjectName) {
        super(p_ObjectName);
        setType(p_ObjectName.getKeyProperty("type"));
    }

// --------------------------------------------------------- Protected Methods

    protected void initialize() {
        setFamily(FAMILY_OWNER);
    }

// --------------------------------------------------------- Properties Methods

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

}