/**
 * JOnAS: Java(TM) Open Application Server
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: jonas-team@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 * --------------------------------------------------------------------------
 * $Id: CDIAnnotationProcessor.java 21566 2011-08-08 12:28:12Z cazauxj $
 * --------------------------------------------------------------------------
 */

package org.ow2.jonas.cdi.weld.internal.standard;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.naming.NamingException;

import org.apache.AnnotationProcessor;

/**
 * Copy/pasted AnnotationProcessor from Weld Tomcat integration module:
 * http://fisheye.jboss.org/browse/weld/servlet/tags/1.0.1-CR2/int/src/main/java/org/jboss/weld/environment/tomcat/WeldAnnotationProcessor.java?r=5792
 * <p/>
 * Change: Using standard {@link BeanManager} interface instead of {@code WeldManager}.
 */
public class CDIAnnotationProcessor implements AnnotationProcessor {

    private final Map<Class<?>, InjectionTarget<?>> injectionTargets;

    private final BeanManager manager;

    public CDIAnnotationProcessor(BeanManager manager) {
        this.manager = manager;
        this.injectionTargets = new ConcurrentHashMap<Class<?>, InjectionTarget<?>>();
    }

    public void processAnnotations(Object instance) throws IllegalAccessException, InvocationTargetException, NamingException {

        // not data-race safe, however doesn't matter, as the injection target created
        // for class A is inter-changable for another injection target created for class A

        // TODO Make this a concurrent cache when we switch to google collections

        Class<?> clazz = instance.getClass();
        if (!injectionTargets.containsKey(clazz)) {
            injectionTargets.put(clazz, manager.createInjectionTarget(manager.createAnnotatedType(clazz)));
        }
        CreationalContext<Object> cc = manager.createCreationalContext(null);
        InjectionTarget<Object> it = (InjectionTarget<Object>) injectionTargets.get(clazz);
        it.inject(instance, cc);
    }

    public void postConstruct(Object arg0) throws IllegalAccessException, InvocationTargetException {}

    public void preDestroy(Object arg0) throws IllegalAccessException, InvocationTargetException {}

}
