/**
 * JOnAS: Java(TM) Open Application Server
 * Copyright (C) 2006-2011 Bull S.A.S.
 * Contact: jonas-team@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: Tomcat6Connector.java 21585 2011-08-08 12:28:55Z cazauxj $
 * --------------------------------------------------------------------------
 */
package org.ow2.jonas.antmodular.jonasbase.web.tomcat6;

import org.ow2.jonas.antmodular.jonasbase.web.tomcat.TomcatConnector;
import org.ow2.jonas.antmodular.web.base.Director;
import org.ow2.jonas.antmodular.web.base.Http;
import org.ow2.jonas.antmodular.web.base.Https;
import org.ow2.jonas.antmodular.web.base.Ajp;

/**
 * Configure Tomcat 6 connector
 * @author Jeremy Cazaux
 */
public class Tomcat6Connector extends TomcatConnector {

    /**
     * Default constructor
     */
    public Tomcat6Connector() {
        super();
    }

    /**
     * Configure a HTTP Connector.
     * @param http HTTP Configuration.
     */
    @Override
    public void addConfiguredHttp(Http http) {
        super.addConfiguredHttp(http, Tomcat6.TOMCAT_CONF_FILE, Tomcat6.INFO);
    }

    /**
     * Configure a HTTPS Connector.
     * @param https HTTPS Configuration.
     */
    @Override
    public void addConfiguredHttps(Https https) {
        super.addConfiguredHttps(https, Tomcat6.TOMCAT_CONF_FILE);
    }

    /**
     * Configure a Director Connector.
     * @param dir Director Configuration.
     */
    @Override
    public void addConfiguredDirector(Director dir) {
        super.addConfiguredDirector(dir, Tomcat6.TOMCAT_CONF_FILE);
    }

    /**
     * Configure an AJP Connector.
     * @param ajp AJP Configuration.
     */
    @Override
    public void addConfiguredAjp(Ajp ajp) {
        super.addConfiguredAjp(ajp, Tomcat6.TOMCAT_CONF_FILE);
    }
}
