/**
 * JOnAS: Java(TM) Open Application Server
 * Copyright (C) 2011 Bull S.A.S.
 * Contact: jonas-team@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: ClusterDaemonActivator.java 21707 2011-09-07 09:44:45Z benoitf $
 * --------------------------------------------------------------------------
 */

package org.ow2.jonas.cluster.daemon.rest.impl;

import com.sun.jersey.spi.container.servlet.ServletContainer;
import org.apache.felix.ipojo.annotations.*;
import org.osgi.service.http.HttpService;
import org.ow2.jonas.cluster.daemon.api.IClusterDaemon;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/**
 * OSGi service to start a camel route connecting
 * the requests to the DeployME OSGI service.
 */
@Component(name="ClusterDaemonActivator", immediate = true)
@Provides
public class ClusterDaemonActivator {
    /**
     * The logger.
     */
    private Log logger = LogFactory.getLog(this.getClass());

    @Requires
    private HttpService httpService;

    @Requires
    private IClusterDaemon clusterDaemon;

    @Property(name = "context", value = "/controller")
    private String context;

    public ClusterDaemonActivator() { }

    @Validate
    public void start() throws Throwable {
        logger.debug("Cluster Daemon REST starting.");
        logger.debug("Context: '" + context + "'");
        httpService.registerServlet(context,
                new ServletContainer(new ClusterDaemonApplication(clusterDaemon)),
                null, null);
    }

    @Invalidate
    public void stop() throws Throwable {
        logger.debug("Cluster Daemon REST Going down.");
        httpService.unregister(context);
    }

}