/**
 * JOnAS: Java(TM) Open Application Server
 * Copyright (C) 2011 Bull S.A.S.
 * Contact: jonas-team@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 * --------------------------------------------------------------------------
 * $Id: IAddonDeployable.java 21795 2011-10-17 01:56:57Z cazauxj $
 * --------------------------------------------------------------------------
 */
package org.ow2.jonas.addon.deploy.api.deployable;

import org.ow2.util.ee.deploy.api.deployable.IDeployable;

import java.util.List;

/**
 * Represents an Addon Deployable
 * @author Jeremy Cazaux
 */
public interface IAddonDeployable extends IDeployable<IAddonDeployable> {

    /**
     * @return the list of deployables of this deployable addon
     */
    List<ISortableDeployable> getDeployables();

    /**
     * @param sortableDeployable Sortable deployable to add to the persistent sortable deployable list
     */
    void addDeployable(final ISortableDeployable sortableDeployable);

}
