/**
 * JOnAS: Java(TM) Open Application Server
 * Copyright (C) 2011 Bull S.A.S.
 * Contact: jonas-team@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 * --------------------------------------------------------------------------
 * $Id: IAddonLogEntry.java 21828 2011-10-23 22:48:27Z cazauxj $
 * --------------------------------------------------------------------------
 */
package org.ow2.jonas.addon.deploy.api.util;

import org.ow2.jonas.workcleaner.LogEntry;

import java.util.List;

/**
 * Interface for IAddonLogEntry
 * @author Jeremy Cazaux
 */
public interface IAddonLogEntry extends LogEntry{

    /**
     * @return the name of the Addon
     */
    String getName();

    /**
     * @return the OSGi deployables as a String
     */
    String getOSGiDeployablesAsAString();

    /**
     * @return the OSGi deployables
     */
    List<String> getOSGiDeployables();

    /**
     * Add an OSGi deployable to the list of OSGi deployables
     * @param osgiDeployable The path to an OSGi deployable
     */
    void addOSGiDeployable(final String osgiDeployable);

    /**
     * @return the OSGi deployables as a String with the following structure osgi{path1,path2,path3}
     */
    void setOSGiDeployables(final List<String> osgiDeployables);

    /**
     * @param osgiDeployables The well formed element which indicate the list of OSGiDeployable with the following
     * structure: osgi{path1,path2,path3}
     */
    void setOSGiDeployables(final String osgiDeployables);

}
