/**
 * JOnAS: Java(TM) Open Application Server
 * Copyright (C) 2011 Bull S.A.S.
 * Contact: jonas-team@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 * --------------------------------------------------------------------------
 * $Id: AddonConfigImpl.java 21828 2011-10-23 22:48:27Z cazauxj $
 * --------------------------------------------------------------------------
 */
package org.ow2.jonas.addon.deploy.impl.config;

import org.ow2.jonas.addon.deploy.api.config.IAddonConfig;

import java.io.File;

/**
 * Allow to retrieve configuration files of an Addon
 * @author Jeremy Cazaux
 */
public class AddonConfigImpl implements IAddonConfig {

    /**
     * Represents the configuration directory of an addon
     */
    private File confDirectory;

    /**
     * Default constructor
     * @param configurationDirectory  The path to the configuration directory
     * @throws Exception
     */
    public AddonConfigImpl(final String configurationDirectory) throws Exception {
        File file = new File(configurationDirectory);
        if (!(file.exists() && file.isDirectory())) {
            throw new Exception("Error. Directory " + configurationDirectory + " doesn't exist");
        }
        this.confDirectory = file;
    }

    /**
     * {@inheritDoc}
     */
    public File getConfigurationFile(String fileName) {
        File confFile = new File(this.confDirectory, fileName);
        if (confFile != null && confFile.exists()) {
            return confFile;
        } else {
            return null;
        }
    }

    /**
     * {@inheritDoc}
     */
    public File getConfigurationDirectory() {
        return this.confDirectory;
    }
}