/**
 * JOnAS: Java(TM) Open Application Server
 * Copyright (C) 2011 Bull S.A.S.
 * Contact: jonas-team@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id:RegistryServiceImpl.java 10372 2007-05-14 13:58:42Z sauthieg $
 * --------------------------------------------------------------------------
 */

package org.ow2.jonas.configadmin.internal;

import org.ow2.jonas.configadmin.internal.model.Configadmin;
import org.ow2.util.archive.api.IFileArchive;
import org.ow2.util.ee.deploy.impl.deployable.AbsDeployable;
import org.ow2.util.plan.deploy.deployable.api.FileDeployable;

/**
 * Created by IntelliJ IDEA.
 * User: guillaume
 * Date: 11/05/11
 * Time: 18:02
 * To change this template use File | Settings | File Templates.
 */
public class ConfigAdminDeployable extends AbsDeployable<ConfigAdminDeployable>
                                   implements FileDeployable<ConfigAdminDeployable, Configadmin> {

    /**
     * Namespace for config-admin.
     */
    public static final String NAMESPACE = "http://jonas.ow2.org/ns/configadmin/1.0";

    /**
     * Transported JAXB metadata.
     */
    private Configadmin data;


    /**
     * Defines and create a deployable for the given archive.
     *
     * @param archive the given archive.
     */
    public ConfigAdminDeployable(IFileArchive archive) {
        super(archive);
    }


    public Configadmin getAttachedData() {
        return data;
    }

    public void setAttachedData(Configadmin attachedData) {
        this.data = attachedData;
    }
}
