/**
 * JOnAS: Java(TM) Open Application Server
 * Copyright (C) 2004-2011 Bull S.A.
 * Contact: jonas-team@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: Db.java 21572 2011-08-08 12:28:35Z cazauxj $
 * --------------------------------------------------------------------------
 */

package org.ow2.jonas.antmodular.jonasbase.db.base;

import java.io.File;

import org.apache.tools.ant.BuildException;
import org.ow2.jonas.antmodular.jonasbase.bootstrap.JOnASBaseTask;
import org.ow2.jonas.antmodular.jonasbase.bootstrap.AbstractJOnASBaseAntTask;
import org.ow2.jonas.antmodular.jonasbase.bootstrap.JTask;

/**
 * Allow to configure the DB service.
 * @author Florent Benoit
 */
public abstract class Db extends AbstractJOnASBaseAntTask {

    /**
     * Info for the logger.
     */
    protected static final String INFO = "[DB] ";

    /**
     * Name of the property for changing the port.
     */
    private static final String PORT_PROPERTY = "jonas.service.db.port";

    /**
     * Name of the property for changing the database name
     */
    private static final String DB_NAME = "jonas.service.db.dbname";

    /**
     * Name of the property for changing login and password
     */
    private static final String USERS = "jonas.service.db.users";

    /**
     * Name of the property for changing the db class
     */
    protected final static String DB_CLASS_PROPERTY = "jonas.service.db.class";

    /**
     * Port number.
     */
    private String portNumber = null;

    /**
     * Name of the database
     */
    private String dbName = null;

    /**
     * Login and password of users
     */
    private String users = null;

    /**
     * Default constructor.
     */
    public Db() {
        super();
    }

    /**
     * Set the port number for the Db service.
     * @param portNumber the port for the Db service
     */
    public void setPort(final String portNumber) {
            this.portNumber = portNumber;
    }

    /***
     * Set the name of the Database
     * @param dbName  name of the database
     */
    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    /**
     * Set all login and password of all users
     * @param users login:password of all users
     */
    public void setUsers(String users) {
        this.users = users;
    }

    /**
     * Check the properties.
     */
    private void checkProperties() {
        if (portNumber == null) {
            throw new BuildException(INFO + "Property 'portNumber' is missing.");
        }
    }

    /**
     * Execute this task.
     */
    public void execute() {
        super.execute();
        checkProperties();

        // Path to JONAS_BASE
        String jBaseConf = this.destDir.getPath() + File.separator + "conf";

        JTask jTask = new JTask();
        jTask.setDestDir(this.destDir);
        jTask.changeValueForKey(INFO, jBaseConf, JOnASBaseTask.JONAS_CONF_FILE,
                                PORT_PROPERTY, portNumber, false);

        if (this.dbName != null) {
            jTask.changeValueForKey(INFO, jBaseConf, JOnASBaseTask.JONAS_CONF_FILE,
                                    DB_NAME, this.dbName, false);
        }
        if (this.users != null) {
            jTask.changeValueForKey(INFO, jBaseConf, JOnASBaseTask.JONAS_CONF_FILE,
                                    USERS, this.users, false);
        }

        addTask(jTask);

    }
}
