/**
 * JOnAS: Java(TM) Open Application Server
 * Copyright (C) 2006-2011 Bull S.A.S.
 * Contact: jonas-team@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: Jetty6.java 21582 2011-08-08 12:28:51Z cazauxj $
 * --------------------------------------------------------------------------
 */
package org.ow2.jonas.antmodular.jonasbase.web.jetty6;

import org.ow2.jonas.antmodular.jonasbase.web.jetty.Jetty;

/**
 * Support Jetty 6 Connector Configuration.
 * @author Jeremy Cazaux
 */
public class Jetty6 extends Jetty {

    /**
     * Name of Jetty configuration file.
     */
    public static final String JETTY_CONF_FILE = "jetty6.xml";

    /**
     * Name of the implementation class for Jetty.
     */
    private static final String JETTY_SERVICE = "org.ow2.jonas.web.jetty6.Jetty6Service";

    /**
     * Default Constructor.
     */
    public Jetty6() {
        super();
    }

    /**
     * Set the port number for the WebContainer
     * @param portNumber  The port to set.
     */
    @Override
    public void setPort(String portNumber) {
        super.setPort(portNumber,JETTY_CONF_FILE, "jetty");
    }

    /**
     * Configure Jetty6's connectors
     * @param jetty6Connector Jetty6 Connector
     */
    public void addConfiguredConnector(final Jetty6Connector jetty6Connector) {
        addTasks(jetty6Connector);
    }

    /**
     * Execute this task
     */
    @Override
    public void execute() {
        super.execute();
        super.createServiceNameReplace(this.JETTY_SERVICE, this.INFO, this.destDir.getAbsolutePath() + this.CONF_DIR);
    }
}
