/**
 * JOnAS: Java(TM) Open Application Server
 * Copyright (C) 2009 Bull S.A.S.
 * Contact: jonas-team@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: DeployableSelector.java 19283 2010-02-24 16:16:26Z benoitf $
 * --------------------------------------------------------------------------
 */
package org.ow2.jonas.ant.jonasbase;

import java.io.File;
import java.util.List;

import org.apache.tools.ant.types.selectors.FilenameSelector;
/**
 * Filter deployables to be copied or excluded.
 * @author eyindanga.
 *
 */
public class DeployableSelector extends FilenameSelector {
    /**
     *
     */
    private List<String> deployableNames;
    /**
     * Default constructor.
     */
    public DeployableSelector() {
    }

    /**
     * Default constructor.
     */
    public DeployableSelector(final List<String> deployableNames) {
        this.deployableNames = deployableNames;
    }
    @Override
    public boolean isSelected(final File basedir, final String filename, final File file) {
        return deployableNames.contains(filename);
    }
}
