/**
 * JOnAS: Java(TM) Open Application Server
 * Copyright (C) 2011 Bull S.A.S.
 * Contact: jonas-team@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 * --------------------------------------------------------------------------
 * $Id: Range.java 21831 2011-10-23 22:48:35Z cazauxj $
 * --------------------------------------------------------------------------
 */
package org.ow2.jonas.addon.deploy.impl.util;

/**
 * Represents a range of values
 * @author Jeremy Cazaux
 */
public class Range {

    /**
     *  The min range value
     */
    private String minRange;

   /**
    *  The max range value
    */
    private String maxRange;

    /**
     * The open range tag
     */
    private String rangeOpenTag;

    /**
     * The close range tag
     */
    private String rangeCloseTag;

    /**
     * Exclusion open tag for range of version
     */
    public static final String EXCLUSION_OPEN_TAG = "(";

    /**
     * Exclusion end tag for range of version
     */
    public static final String EXCLUSION_CLOSE_TAG = ")";

    /**
     * Inclusion open tag for range of version
     */
    public static final String INCLUSION_OPEN_TAG = "[";

    /**
     * Inclusion end tag for range of version
     */
    public static final String INCLUSION_CLOSE_TAG = "]";

    /**
     * Default constructor
     * @param isInclusionOpenTag True if it's an inclusion open tag
     * @param isInclusionCloseTag True if it's an inclusion close tag
     * @param minRange The min range value to set
     */
    public Range(Boolean isInclusionOpenTag, Boolean isInclusionCloseTag, String minRange) {
        this.minRange = minRange;

        if (isInclusionOpenTag) {
            this.rangeOpenTag = INCLUSION_OPEN_TAG;
        } else {
            this.rangeOpenTag = EXCLUSION_OPEN_TAG;
        }

        if (isInclusionCloseTag) {
            this.rangeCloseTag = INCLUSION_CLOSE_TAG;
        } else {
            this.rangeCloseTag = EXCLUSION_CLOSE_TAG;
        }
    }

    /**
     * @param maxRange The max range value to set
     */
    public void setMaxRange(String maxRange) {
        this.maxRange = maxRange;
    }

    /**
     * Check if the given value is support
     * @param value  The value to check
     */
    public boolean isSupported(String value) {

        //minRange == value
        if (this.minRange.equals(value)) {
                return true;

        //minRange < value
        } else if (this.minRange.compareTo(value) < 0 && this.maxRange != null) {

            //maxRange == value
            if (this.maxRange.equals(value)) {
                return true;

            //maxRange > value
            } else if (this.maxRange.compareTo(value) > 0) {
                return true;
            } else {
                return false;
            }

        } else {
            return false;
        }
    }
}
