/**
 * JOnAS: Java(TM) Open Application Server
 * Copyright (C) 2006-2011 Bull S.A.S.
 * Contact: jonas-team@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: Tomcat7Connector.java 21586 2011-08-08 12:28:57Z cazauxj $
 * --------------------------------------------------------------------------
 */
package org.ow2.jonas.antmodular.jonasbase.web.tomcat7;

import org.ow2.jonas.antmodular.jonasbase.web.tomcat.TomcatConnector;
import org.ow2.jonas.antmodular.web.base.Ajp;
import org.ow2.jonas.antmodular.web.base.Director;
import org.ow2.jonas.antmodular.web.base.Http;
import org.ow2.jonas.antmodular.web.base.Https;

/**
 * Configure a Tomcat 7 Connector
 * @author Jeremy Cazaux
 */
public class Tomcat7Connector extends TomcatConnector {

    public Tomcat7Connector() {
        super();
    }

    /**
     * Configure a HTTP Connector.
     * @param http HTTP Configuration.
     */
    @Override
    public void addConfiguredHttp(Http http) {
        super.addConfiguredHttp(http, Tomcat7.TOMCAT_CONF_FILE, Tomcat7.INFO);
    }

    /**
     * Configure a HTTPS Connector.
     * @param https HTTPS Configuration.
     */
    @Override
    public void addConfiguredHttps(Https https) {
        super.addConfiguredHttps(https, Tomcat7.TOMCAT_CONF_FILE);
    }

    /**
     * Configure a Director Connector.
     * @param dir Director Configuration.
     */
    @Override
    public void addConfiguredDirector(Director dir) {
        super.addConfiguredDirector(dir, Tomcat7.TOMCAT_CONF_FILE);
    }

    /**
     * Configure an AJP Connector.
     * @param ajp AJP Configuration.
     */
    @Override
    public void addConfiguredAjp(Ajp ajp) {
        super.addConfiguredAjp(ajp, Tomcat7.TOMCAT_CONF_FILE);
    }
}
