/**
 * JOnAS: Java(TM) Open Application Server
 * Copyright (C) 2003-2004 Bull S.A.
 * Contact: jonas-team@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: ExceptionHelper.java 15428 2008-10-07 11:20:29Z sauthieg $
 * --------------------------------------------------------------------------
 */

package org.ow2.jonas.lib.ejb21;

import org.objectweb.jorm.api.PException;
import org.objectweb.medor.api.MedorException;

/**
 * @author S.Chassande-Barrioz
 */
public class ExceptionHelper {

	public static void printException(Exception e) {
        if (e instanceof PException
			&& ((PException) e).getNestedException()!=null) {
			printException(((PException) e).getNestedException());
		}
		else if (e instanceof MedorException
			&& ((MedorException) e).getNestedException()!=null) {
			System.out.println(e.getMessage());
			printException(((MedorException) e).getNestedException());
		}
		else
			e.printStackTrace();
    }

	public static Exception getException(Exception e) {
		if (e instanceof PException
			&& ((PException) e).getNestedException()!=null) {
			return getException(((PException) e).getNestedException());
		}
		else if (e instanceof MedorException
			&& ((MedorException) e).getNestedException()!=null) {
			return getException(((MedorException) e).getNestedException());
		}
		else
			return e;
	}
}
