/**
 * JOnAS: Java(TM) Open Application Server
 * Copyright (C) 2011 Bull S.A.S.
 * Contact: jonas-team@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 * --------------------------------------------------------------------------
 * $Id: AddonDeployableImpl.java 22060 2012-01-29 12:43:56Z cazauxj $
 * --------------------------------------------------------------------------
 */
package org.ow2.jonas.addon.deploy.impl.deployable;

import org.ow2.jonas.addon.deploy.api.deployable.IAddonDeployable;
import org.ow2.jonas.addon.deploy.api.deployable.ISortableDeployable;
import org.ow2.util.archive.api.IArchive;
import org.ow2.util.ee.deploy.impl.deployable.AbsDeployable;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

import java.util.ArrayList;
import java.util.List;

/**
 * Represents an Addon Deployable
 * @author Jeremy Cazaux
 */
public class AddonDeployableImpl extends AbsDeployable<IAddonDeployable> implements IAddonDeployable {

    /**
     * The logger
     */
    private static Log logger = LogFactory.getLog(AddonDeployableImpl.class);

    /**
     * List of deployables
     */
    private List<ISortableDeployable> deployables = null;

    /**
     * Defines and create a deployable for the given archive.
     * @param archive the given archive.
     */
    public AddonDeployableImpl(final IArchive archive) {
        super(archive);
        this.deployables = new ArrayList<ISortableDeployable>();
    }

    /**
     * @return the list of deployables of this deployable addon
     */
    public List<ISortableDeployable> getDeployables() {
        return deployables;
    }

    /**
     * @param sortableDeployable Sortable deployable to add to the persistent sortable deployable list
     */
    public void addDeployable(final ISortableDeployable sortableDeployable) {
        this.deployables.add(sortableDeployable);
    }
}
