/**
 * JOnAS: Java(TM) Open Application Server
 * Copyright (C) 1999-2007 Bull S.A.S.
 * Contact: jonas-team@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: SQLManager.java 21566 2011-08-08 12:28:12Z cazauxj $
 * --------------------------------------------------------------------------
 */

package org.ow2.jonas.resource.internal;

import java.sql.PreparedStatement;
import java.sql.SQLException;

import org.ow2.jonas.resource.internal.cm.ManagedConnectionInfo;


/**
 * SQL Manager to be used with {@link PreparedStatement}
 * @author ehardesty
 */
public interface SQLManager {

    /**
     * Get the specified PreparedStatement
     * @param mcinfo ManagedConnectionInfo
     * @param conn Object connection
     * @param user String
     * @param sql String
     * @return PreparedStatment
     * @throws SQLException if an Exception occurs
     */
     PreparedStatement getPStatement(ManagedConnectionInfo mcinfo,
                                     Object conn,
                                     String user,
                                     String sql)
         throws SQLException;

     /**
      * Get the specified PreparedStatement
      * @param mcinfo ManagedConnectionInfo
      * @param conn Object connection
      * @param user String
      * @param sql String
      * @param resultSetType int
      * @param resultSetConcurrency int
      * @return PreparedStatment
      * @throws SQLException if an Exception occurs
      */
     PreparedStatement getPStatement(ManagedConnectionInfo mcinfo,
                                     Object conn,
                                     String user,
                                     String sql,
                                     int resultSetType,
                                     int resultSetConcurrency)
         throws SQLException;


// JDK 1.4
     /**
      * Get the specified PreparedStatement
      * @param mcinfo ManagedConnectionInfo
      * @param conn Object connection
      * @param user String
      * @param sql String
      * @param autoGeneratedKeys key
      * @return PreparedStatment
      * @throws SQLException if an Exception occurs
      */
     PreparedStatement getPStatement(ManagedConnectionInfo mcinfo,
                                     Object conn,
                                     String user,
                                     String sql,
                                     int autoGeneratedKeys)
         throws SQLException;

     /**
      * Get the specified PreparedStatement
      * @param mcinfo ManagedConnectionInfo
      * @param conn Object connection
      * @param user String
      * @param sql String
      * @param columnIndexes int []
      * @return PreparedStatment
      * @throws SQLException if an Exception occurs
      */
     PreparedStatement getPStatement(ManagedConnectionInfo mcinfo,
                                     Object conn,
                                     String user,
                                     String sql,
                                     int[] columnIndexes)
         throws SQLException;

     /**
      * Get the specified PreparedStatement
      * @param mcinfo ManagedConnectionInfo
      * @param conn Object connection
      * @param user String
      * @param sql String
      * @param resultSetType int
      * @param resultSetConcurrency int
      * @param resultSetHoldability int
      * @return PreparedStatment
      * @throws SQLException if an Exception occurs
      */
     PreparedStatement getPStatement(ManagedConnectionInfo mcinfo,
                                     Object conn,
                                     String user,
                                     String sql,
                                     int resultSetType,
                                     int resultSetConcurrency,
                                     int resultSetHoldability)
         throws SQLException;

     /**
      * Get the specified PreparedStatement
      * @param mcinfo ManagedConnectionInfo
      * @param conn Object connection
      * @param user String
      * @param sql String
      * @param columnNames String []
      * @return PreparedStatment
      * @throws SQLException if an Exception occurs
      */
      PreparedStatement getPStatement(ManagedConnectionInfo mcinfo,
                                      Object conn,
                                      String user,
                                      String sql,
                                      String[] columnNames)
         throws SQLException;

      /**
       * @return Returns the maxPstmtPoolSize
       */
       int getMaxPstmtPoolSize();
 }

