/**
 * JOnAS: Java(TM) Open Application Server
 * Copyright (C) 2012 Bull S.A.S.
 * Contact: jonas-team@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 * --------------------------------------------------------------------------
 * $Id: JOnASNamingResources.java 22248 2012-03-19 15:04:06Z benoitf $
 * --------------------------------------------------------------------------
 */

package org.ow2.jonas.web.tomcat7;

import org.apache.catalina.deploy.ContextEnvironment;
import org.apache.catalina.deploy.NamingResources;

/**
 * Manages our own Naming Resources as all parsing is already done by JOnAS.
 * @author Florent Benoit
 */
public class JOnASNamingResources extends NamingResources {

    /**
     * Serial Version UID.
     */
    private static final long serialVersionUID = -5216733209343793352L;
    
    
    /**
     * Add an environment entry for this web application.
     * @param environment New environment entry
     */
    public void addEnvironment(ContextEnvironment environment) {
        if (environment != null && environment.getType() == null) {
            environment.setType("java.lang.Object");
        }
        super.addEnvironment(environment);
    }

}
