/**
 * JOnAS: Java(TM) Open Application Server
 * Copyright (C) 2005 Bull S.A.
 * Contact: jonas-team@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: WSDDNoopProvider.java 21566 2011-08-08 12:28:12Z cazauxj $
 * --------------------------------------------------------------------------
 */
package org.ow2.jonas.ws.axis;

import org.apache.axis.EngineConfiguration;
import org.apache.axis.Handler;
import org.apache.axis.deployment.wsdd.WSDDProvider;
import org.apache.axis.deployment.wsdd.WSDDService;

/**
 * JOnAS Noop Provider.
 *
 * @author Guillaume Sauthier
 */
public class WSDDNoopProvider extends WSDDProvider {

    /**
     * JOnAS Noop Provider name
     */
    public static final String PROVIDER_NAME = "Noop";

    /**
     * @return Returns the JOnAS EJB Provider name
     */
    public String getName() {
        return PROVIDER_NAME;
    }

    /**
     * Returns the JOnAS Noop Provider.
     *
     * @param service not used
     * @param registry not used
     *
     * @return Returns the JOnAS Noop Provider.
     *
     * @throws Exception never thrown
     */
    public Handler newProviderInstance(WSDDService service, EngineConfiguration registry) throws Exception {
        return new org.ow2.jonas.ws.axis.NoopProvider();
    }

}

