/**
 * JOnAS: Java(TM) Open Application Server
 * Copyright (C) 2011 Bull S.A.S.
 * Contact: jonas-team@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 * --------------------------------------------------------------------------
 * $Id: IAddonDeployer.java 21979 2011-12-11 22:27:25Z cazauxj $
 * --------------------------------------------------------------------------
 */
package org.ow2.jonas.addon.deploy.api.deployer;

import org.ow2.jonas.addon.deploy.api.deployable.IAddonDeployable;
import org.ow2.util.ee.deploy.api.deployer.IDeployer;

/**
 * Represents an Addon Deployer
 * @author Jeremy Cazaux
 */
public interface IAddonDeployer extends IDeployer<IAddonDeployable> {

    /**
     * Test if the specified unpack name is already deployed or not.
     * @param unpackName the name of the Addon file.
     * @return true if the Addon is deployed, else false.
     */
    boolean isAddonDeployedByWorkName(final String unpackName);

}
