/**
 * JOnAS: Java(TM) Open Application Server
 * Copyright (C) 2011 Bull S.A.S.
 * Contact: jonas-team@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 * --------------------------------------------------------------------------
 * $Id: IAddonDeployerLog.java 22065 2012-01-31 13:14:39Z joaninh $
 * --------------------------------------------------------------------------
 */
package org.ow2.jonas.addon.deploy.api.deployer;

import org.ow2.jonas.addon.deploy.api.util.IAddonLogEntry;
import org.ow2.jonas.workcleaner.DeployerLogException;
import org.ow2.jonas.workcleaner.IDeployerLog;
import org.ow2.jonas.workcleaner.LogEntry;

import java.io.File;
import java.util.Vector;

/**
 * Interface for the addon deployer log
 * @author Jeremy Cazaux
 */
public interface IAddonDeployerLog<T extends LogEntry> extends IDeployerLog<T> {

    /**
     * Add the entry and return the new entries.
     * @param original the name of the file
     * @param copy the copy of the file
     * @return the new vector of IAddonLogEntry item.
     * @throws DeployerLogException if the add can't be done
     */
    Vector<IAddonLogEntry> addEntry(final String name, final File original, final File copy) throws DeployerLogException;
}
