/**
 * JOnAS: Java(TM) Open Application Server
 * Copyright (C) 2011 Bull S.A.S.
 * Contact: jonas-team@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 * --------------------------------------------------------------------------
 * $Id: IAddonStructure.java 21830 2011-10-23 22:48:33Z cazauxj $
 * --------------------------------------------------------------------------
 */
package org.ow2.jonas.addon.deploy.api.util;

import java.io.File;

/**
 * Sets some constants for an Addon Structure
 * @author Jeremy Cazaux
 */
public interface IAddonStructure {

    /**
     * Configuration directory of an Addon
     */
    String CONF_DIRECTORY = "conf";

    /**
     * Bin directory of an Addon
      */
    String BIN_DIRECTORY = "bin";

    /**
     * Deployable directory of an Addon
     */
    String DEPLOY_DIRECTORY = "deploy";

    /**
     * Ant directory of an Addon
     */
    String ANT_DIRECTORY = "ant";

    /**
     * Addon metadata filename
     */
    String METADATA_FILENAME = "jonas-addon.xml";

    /**
     * META-INF directory name
     */
    String META_INF = "META-INF";

    /**
     * The metadata file of an Addon deployable
     */
    String JONAS_ADDON_METADATA = META_INF + File.separator + METADATA_FILENAME;

    /**
     * The addon metadata zip entry
     */
    String JONAS_ADDON_METADATA_ZIP_ENTRY = META_INF + "/" + METADATA_FILENAME;

}
