/**
 * JOnAS: Java(TM) Open Application Server
 * Copyright (C) 1999-2009 Bull S.A.S.
 * Contact: jonas-team@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: HandlerRuleSet.java 16276 2009-01-21 17:51:35Z sauthieg $
 * --------------------------------------------------------------------------
 */

package org.ow2.jonas.deployment.common.rules;

import org.apache.commons.digester.Digester;

/**
 * This class defines a rule to analyze handler
 * @author Florent Benoit
 */
public class HandlerRuleSet extends JRuleSetBase {

    /**
     * Construct an object with a specific prefix
     * @param prefix prefix to use during the parsing
     */
    public HandlerRuleSet(String prefix) {
        super(prefix);
    }

    /**
     * Add a set of rules to the digester object
     * @param digester Digester instance
     */
    public void addRuleInstances(Digester digester) {
        digester.addObjectCreate(prefix + "handler",
                                 "org.ow2.jonas.deployment.common.xml.Handler");

        digester.addSetNext(prefix + "handler",
                            "addHandler",
                            "org.ow2.jonas.deployment.common.xml.Handler");

        digester.addCallMethod(prefix + "handler/handler-name",
                               "setHandlerName", 0);
        digester.addCallMethod(prefix + "handler/handler-class",
                               "setHandlerClass", 0);

        digester.addRuleSet(new InitParamRuleSet(prefix + "handler/"));
        digester.addRuleSet(new SoapHeaderRuleSet(prefix + "handler/"));

        digester.addCallMethod(prefix + "handler/soap-role",
                               "addSoapRole", 0);

        digester.addCallMethod(prefix + "handler/port-name",
                               "addPortName", 0);
    }

    /**
     * @return the namespaceURI that is relevant for this RuleSet.
     */
    @Override
    public String getNamespaceURI() {
        return "http://java.sun.com/xml/ns/j2ee";
    }
    
}
